from fastapi import FastAPI, Query

from query import query_search

# --------------------------------------------------
# ENV + APP
# --------------------------------------------------



app = FastAPI(
    title="TracWater RAG Chatbot API",
    description="Session-aware RAG chatbot with relevance threshold",
    version="1.1"
)

# --------------------------------------------------
# API ENDPOINT
# --------------------------------------------------

@app.get("/ask")
def ask_question(q: str = Query(..., description="User question"),session_id: str = Query(..., description="Session identifier"),):
    
    return query_search(q=q, session_id=session_id)
