# TracWater RAG Chatbot

This repository contains a Retrieval-Augmented Generation (RAG) chatbot backend
built for TracWater.

## Features
- Website and DOCX ingestion
- Semantic search using FAISS
- OpenAI embeddings
- Session-aware conversational memory
- Relevance thresholding
- FastAPI REST API

## Project Structure
- `manual_scrape.py` – website scraping
- `extract_docx_folder.py` – DOCX ingestion
- `chunk_data.py` – chunking pipeline
- `embed_store.py` – embeddings + FAISS
- `query.py` – core RAG logic
- `api.py` – FastAPI layer

## Setup

```bash
python -m venv venv
source venv/bin/activate
pip install -r requirements.txt
Environment Variables
env
Copy code
OPENAI_API_KEY=your_key_here
Run API
bash
Copy code
uvicorn api:app --reload --port 8000
Notes
Vector stores and scraped data are intentionally not committed.

For internal company use only.
